<?php
// Get the current directory and the server URL
$currentDir = __DIR__;
$serverUrl = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']);

// Supported image file extensions
$imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];

// Initialize an array to store image URLs
$imageUrls = [];

// Open the directory and read files
if ($handle = opendir($currentDir)) {
    while (false !== ($file = readdir($handle))) {
        // Get the file extension
        $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
        
        // Check if the file is an image
        if (in_array($extension, $imageExtensions)) {
            $imageUrls[] = $serverUrl . '/' . $file; // Add the full URL of the image
        }
    }
    closedir($handle);
}

// Return the images as a JSON object
header('Content-Type: application/json');
echo json_encode(['images' => $imageUrls]);
