from PIL import Image
import asyncio
import argparse
from pyppeteer import launch

async def html_to_image(url, output_path, final_output_path):
    try:
        # Launch the browser
        browser = await launch(
            executablePath='/usr/bin/chromium-browser',
            headless=True,
            args=['--no-sandbox']
        )    
        page = await browser.newPage()
        await page.setViewport({'width': 1400, 'height': 1300})  # Set desired width and height

        # Open the URL
        await page.goto(url)
        
        # Take a screenshot and save it to the output path
        await page.screenshot({'path': output_path})
        
        # Resize the screenshot using Pillow
        with Image.open(output_path) as img:
            # Save the image with lower quality (in JPEG format)
            img.save(final_output_path, 'JPEG', quality=20)  # Lower quality (range 0-100)

        print("Success: Image successfully captured and saved!")
        print(f"Output saved at: {final_output_path}")

    except Exception as e:
        print(f"An error occurred: {e}")

    finally:
        # Ensure the browser is closed
        try:
            await browser.close()
        except Exception as browser_error:
            print(f"An error occurred while closing the browser: {browser_error}")

# Set up command-line argument parsing
parser = argparse.ArgumentParser(description="Convert a webpage URL to an image.")
parser.add_argument('url', type=str, help="The URL of the webpage to capture")
parser.add_argument('output_path', type=str, help="The path to save the output image")
parser.add_argument('final_output_path', type=str, help="The path to save the resized output image")

# Parse arguments
args = parser.parse_args()

# Run the function asynchronously with the provided URL and output path
try:
    asyncio.get_event_loop().run_until_complete(
        html_to_image(args.url, args.output_path, args.final_output_path)
    )
except Exception as main_error:
    print(f"An unexpected error occurred in the main program: {main_error}")
